package edu.uky.ai.lp.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import edu.uky.ai.lp.Game;
import edu.uky.ai.lp.Settings;

public class GamePanel extends JPanel {

	private static final long serialVersionUID = Settings.VERSION_UID;

	public final Game game;
	
	public GamePanel(Game map) {
		this.game = map;
		setPreferredSize(new Dimension(Images.MAP.getWidth() * Settings.ZOOM, Images.MAP.getHeight() * Settings.ZOOM));
	}
	
	@Override
	public void paintComponent(Graphics g) {
		Graphics2D g2d = (Graphics2D) g;
		AffineTransform transform = g2d.getTransform();
		transform.scale(Settings.ZOOM, Settings.ZOOM);
		g2d.setTransform(transform);
		g2d.drawImage(Images.MAP, 0, 0, null);
		for(int rank=3; rank>=0; rank--) {
			for(int file=0; file<4; file++) {
				if(game.glitter(file, rank))
					draw(g2d, Images.GOLD, file, rank);
				if(game.player(file, rank))
					draw(g2d, Images.PLAYER, file, rank);
				if(game.pit(file, rank))
					draw(g2d, Images.PIT, file, rank);
				if(game.wumpus(file, rank))
					draw(g2d, Images.WUMPUS, file, rank);
				if(game.breeze(file, rank))
					draw(g2d, Images.BREEZE, file, rank);
				if(game.stench(file, rank))
					draw(g2d, Images.STENCH, file, rank);
				if(!game.visited(file, rank))
					draw(g2d, Images.FOG, file, rank);
			}
		}
	}
	
	private final void draw(Graphics2D g2d, BufferedImage image, int file, int rank) {
		int x = (file + 1) * 24;
		int y = Math.abs(rank - 4) * 24;
		if(image == Images.PLAYER || image == Images.WUMPUS)
			y -= 5;
		g2d.drawImage(image, x, y, null);
	}
}
